<?php
include 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // 1. Get Data (Notice the new locName line)
    $matric  = $_POST['matric']  ?? "Unknown";
    $telco   = $_POST['telco']   ?? "Unknown";
    $lat     = $_POST['lat']     ?? "0.0";
    $long    = $_POST['long']    ?? "0.0";
    $netType = $_POST['netType'] ?? "Unknown";
    $ping    = $_POST['ping']    ?? "0";
    $dl      = $_POST['dl']      ?? "0.0";
    $ul      = $_POST['ul']      ?? "0.0";
    $dbm     = $_POST['dbm']     ?? "0";
    
    // NEW LINE: Receive the name from Flutter
    $locName = $_POST['locName'] ?? "Unknown Area"; 

    date_default_timezone_set("Asia/Kuala_Lumpur");
    $date = date("Y-m-d");
    $time = date("H:i:s");

    // 2. Prepare Insert (Added location_name to the list)
    $stmt = $conn->prepare("INSERT INTO test_results (matric_no, latitude, longitude, network_type, telco_provider, ping_ms, download_speed, upload_speed, signal_dbm, location_name, test_date, test_time) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    if ($stmt) {
        // 3. Bind Parameters (There are now 12 's')
        // We added $locName in the correct position
        $stmt->bind_param("ssssssssssss", $matric, $lat, $long, $netType, $telco, $ping, $dl, $ul, $dbm, $locName, $date, $time);

        if ($stmt->execute()) {
            echo json_encode(["status" => "success"]);
        } else {
            echo json_encode(["status" => "error", "message" => $stmt->error]);
        }
        $stmt->close();
    } else {
        echo json_encode(["status" => "error", "message" => "Prepare failed: " . $conn->error]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid Request"]);
}

$conn->close();
?>